// Demo_VCDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Demo_VC.h"
#include "Demo_VCDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDemo_VCDlg dialog

CDemo_VCDlg::CDemo_VCDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDemo_VCDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDemo_VCDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDemo_VCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDemo_VCDlg)
	DDX_Control(pDX, IDC_PICT, m_Pict);
	DDX_Control(pDX, IDC_CL2005OCXCTRL1, m_CL2005);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDemo_VCDlg, CDialog)
	//{{AFX_MSG_MAP(CDemo_VCDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_BN_CLICKED(IDC_BUTTON2, OnButton2)
	ON_BN_CLICKED(IDC_BUTTON3, OnButton3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDemo_VCDlg message handlers

BOOL CDemo_VCDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDemo_VCDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDemo_VCDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

#define		_MAXHEIGHT		512
#define		_MAXWIDTH		2048

void	CDemo_VCDlg::PictToBuff(CDC *dc, LineType *PictBuf,
						int  PictWidth, int PictHeight,
						WORD Width,WORD Height,
						BYTE Color)
{
int		x,y,z,EndX,EndY,vC;
BYTE	v;
BYTE	_ROLE[]={0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};

	// 
	for (x=0;x<_MAXWIDTH/8;++x)
		for (y=0;y<_MAXHEIGHT;++y) PictBuf[y][x] = 0;

	// ͼƬĿ߾ȡͼƬĿ,֤ݲԽ
	if (PictWidth>Width)   EndX=Width;  else EndX=PictWidth;
	if (PictHeight>Height) EndY=Height; else EndY=PictHeight;

	// ߶ȺͿ
    // Ƚȡɫ
	for (y=0;y<EndY;++y)
		for (x=0;x<(EndX+7)/8;++x)
		{
			v=0;
			for (z=0;z<8;++z)
			{
				vC = dc->GetPixel(x*8+z,y);
				if ((vC & RGB(0xff,0,0))>RGB(0x20,0,0)) v |= _ROLE[z];
			}
			PictBuf[y][x] = v;
		}
    // ˫ɫٽȡɫ
	if (Color!=0)
	{
		for (y=0;y<EndY;++y)
			for (x=0;x<(EndX+7)/8;++x)
			{
				v=0;
				for (z=0;z<8;++z)
				{
					vC = dc->GetPixel(x*8+z,y);
					if ((vC & RGB(0,0xff,0))>RGB(0,0x20,0)) v |= _ROLE[z];
				}
				PictBuf[y+Height][x] = v;
			}
	}
}

#define		LedType         2       // ƿ,1-4
#define		LedNum          0       // ƿ,ɿƿϵ趨
#define		LedWidth        384     // ,CL2005Ŀϵͳ趨
#define		LedHeight       128     // ߶,CL2005Ŀϵͳ趨
#define		LedColor        1       // ɫ, 0:ɫ,1:˫ɫ, CL2005Ŀϵͳ趨

#define		ComPort         1       // п
#define		ComBaudRate     38400   // ͨѶ,ɿƿ趨
#define		ComDelay        1000    // ȴӦʱ,ͨѶʺݰС
									//      һȡ800

void CDemo_VCDlg::OnButton1() 
{
LineType	SendBuf[512];
RECT		rect;
BOOL		bOK;
ProgType	ProgBuff[10];

	m_Pict.GetWindowRect(&rect);
	PictToBuff(m_Pict.GetDC(),SendBuf,rect.right-rect.left,rect.bottom-rect.top,LedWidth,LedHeight,LedColor);
	if (!m_CL2005.ComInitial(ComPort,ComBaudRate,ComDelay))
		MessageBox("ʼʧ","ʾͼƬ",MB_OK);
	else
	{
		bOK = m_CL2005.SetLEDProperty(LedType,LedNum,LedWidth,LedHeight,LedColor,1);
		// ͼƬ
//		if (bOK) bOK=m_CL2005.SendPicture(0,(long)SendBuf);

		// ͼƬĹ̿
		if (bOK)
		{
			int i=0;
			while (bOK && (i<m_CL2005.GetPictureSendTimes()))
			{
				bOK &= m_CL2005.SendPictureEx(0,i,(long)SendBuf);
				i++;
			}
		}

		if (bOK)
		{
            ProgBuff[0].PictIndex   = 0;   // ͼƬ0Ĳ
            ProgBuff[0].Enter       = 0;   // 뷽ʽ0
            ProgBuff[0].Leave       = 2;   // ˳ʽ2
            ProgBuff[0].Speed       = 10;  // ٶ
            ProgBuff[0].StayTime    = 5;   // ͣʱ
            ProgBuff[0].bFollowPlay = 0;   // ǽģʽ
            ProgBuff[0].bShowTimer  = 0;   // ҳʱ
            ProgBuff[0].TimerMode   = 0;   // ʾʱ
            ProgBuff[0].bTimerPlay  = 0;   // Ƕʱ

            ProgBuff[1].PictIndex   = 0;   // ͼƬ0Ĳ
            ProgBuff[1].Enter       = 1;   // 뷽ʽ1
            ProgBuff[1].Leave       = 1;   // ˳ʽ1
            ProgBuff[1].Speed       = 0;   // ٶ
            ProgBuff[1].StayTime    = 5;   // ͣʱ
            ProgBuff[1].bFollowPlay = 0;   // ǽģʽ
            ProgBuff[1].bShowTimer  = 0;   // ҳʱ
            ProgBuff[1].TimerMode   = 0;   // ʾʱ
            ProgBuff[1].bTimerPlay  = 0;   // Ƕʱ
			bOK = m_CL2005.SendProgList(2,(long)ProgBuff);
		}
		m_CL2005.CloseCL2005();
		if (bOK) MessageBox("ͳɹ","ͼƬ",MB_OK);
        else	 MessageBox("ʧ","ͼƬ",MB_OK);
	}
}

void CDemo_VCDlg::OnButton2() 
{
char	str[256];
BOOL	bOK;
	strcpy(str,"`01`02`03");	
    bOK = m_CL2005.ComInitial(ComPort,ComBaudRate,ComDelay);
    if (!bOK) MessageBox("ڳʼʧ","ʾ",MB_OK);
    else
    {
        bOK = m_CL2005.SetLEDProperty(LedType,LedNum,LedWidth,LedHeight,LedColor,1);
		if (bOK) bOK = m_CL2005.SwitchToBank(0);
		if (bOK) bOK = m_CL2005.ShowString(1,LedWidth-3*16,0,0,(long)str);
		if (bOK) bOK = m_CL2005.SwitchToBank(1);
        m_CL2005.CloseCL2005();
        if (bOK) MessageBox("ͳɹ","ʾ",MB_OK);
        else	 MessageBox("ʧ","ʾ",MB_OK);
	}
}

void CDemo_VCDlg::OnButton3() 
{
BOOL	bOK;
    bOK = m_CL2005.ComInitial(ComPort,ComBaudRate,ComDelay);
    if (!bOK) MessageBox("ڳʼʧ","λƿ",MB_OK);
    else
    {
        bOK = m_CL2005.SetLEDProperty(LedType,LedNum,LedWidth,LedHeight,LedColor,1);
        if (bOK) bOK=m_CL2005.Reset();
        m_CL2005.CloseCL2005();
        if (bOK) MessageBox("ͳɹ","λƿ",MB_OK);
        else	 MessageBox("ʧ","λƿ",MB_OK);
    }
}
